/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.mrp2;

import com.google.common.collect.Maps;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.mrp2.MrpNamingStrategy;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.Superplan;
import java.util.Map;
import javax.annotation.Nonnull;

public class MaterialIncrementalMrpNamingStrategy
implements MrpNamingStrategy {
    private final Map<Material, Integer> nextNumber;
    private final int startingNumber;
    private final Superplan superplan;
    private final String separator;

    public MaterialIncrementalMrpNamingStrategy(Superplan superplan, int startingNumber, String separator) {
        this.superplan = superplan;
        this.startingNumber = startingNumber;
        this.separator = separator;
        this.nextNumber = Maps.newHashMap();
    }

    public MaterialIncrementalMrpNamingStrategy(Superplan superplan) {
        this(superplan, 0, ":");
    }

    private boolean containsId(String id) {
        return this.superplan.getSupplyRequest(id) != null || this.superplan.getGor(id) != null;
    }

    private String createId(Material mat, int n) {
        return mat.getName() + this.separator + n;
    }

    private String createNextId(Material mat) {
        int n = this.startingNumber;
        if (this.nextNumber.containsKey(mat)) {
            n = this.nextNumber.get(mat);
        }
        while (this.containsId(this.createId(mat, n))) {
            ++n;
        }
        this.nextNumber.put(mat, n + 1);
        return this.createId(mat, n);
    }

    @Override
    @Nonnull
    public String generateSrId(@Nonnull Material mat, double qty, long time, @Nonnull SupplyRequest.State state) {
        return this.createNextId(mat);
    }

    @Override
    @Nonnull
    public String generateGorId(@Nonnull Product product, double qty, long dueDate, @Nonnull GeneralizedOrderRequest.State state) {
        return this.createNextId(product);
    }
}

